package de.bebagoe.util.coll;
import java.util.Arrays;

public class SimpleList<E> {
	private Object[] elements;
	private final static int DEF_INIT_SIZE = 16;
	private int initSize;
	private int size;

	public SimpleList(int len) {
        if (len <= 0)
           throw new IllegalArgumentException("Die initiale Größe muss positiv sein.");
        initSize = len;
        elements = new Object[len];
        super();
	}

	public SimpleList() {
        initSize = DEF_INIT_SIZE;
        elements = new Object[DEF_INIT_SIZE];
        super();
	}

	public void add(E element) {
		if (size == elements.length)
			elements = Arrays.copyOf(elements, elements.length + initSize);
		elements[size++] = element;
	}

//	@SuppressWarnings("unchecked")
//	// Casting erforderlich, weil kein Array vom Typ E erstellt werden kann.
//	// Das Array elements kann nur Objekte vom Typ E enthalten.
//	public E get(int index) {
//		if (index >= 0 && index < size)
//			return (E) elements[index];
//		else
//			return null;
//	}
	
	public E get(int index) {
		if (index >= 0 && index < size) {
			// Casting erforderlich, weil man kein Array vom Typ E erstellen kann.
			// Das Array elements kann nur Objekte vom Typ E enthalten.
			@SuppressWarnings("unchecked")
			E result = (E) elements[index];
			return result;
		} else
			return null;
	}
	
	public int size() {return size;}

	public int capacity() {return elements.length;}
}